# SPDX-License-Identifier: CC0-1.0

unit module Speaking;

only sub speak(%speaker, Str $speaks) is export {
    my $speech =
        "\e[" ~ %speaker{"CSI"} ~ "m"
        #`[ The “CSI” key is an ANSI escape code of
            the Control Sequence Introducer's sequences.

            https://en.wikipedia.org/wiki/ANSI_escape_code#CSI_(Control_Sequence_Introducer)_sequences
            for more information ]
        ~ "\e[1m" ~ %speaker{"NAME"} ~ "\e[0m"
        ~ "\e[2m: \e[0m"
        ~ "\e[3m" ~ $speaks ~ "\e[0m";
    say $speech; return $speech;
    # the Return's for test cases in general
};
